(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28508,        749]*)
(*NotebookOutlinePosition[     29351,        776]*)
(*  CellTagsIndexPosition[     29307,        772]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(k[x_, s_] := \((4 + \((x - s)\)^2)\)^\((\(-1\))\);\)\)], "Input"],

Cell[BoxData[
    \(\(f[x_] := 
        1 + x^2 + 
          x^5 - \((2/Pi)\)*
            Integrate[k[x, s]*\((1 + s^2 + s^5)\), {s, 0, 1}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x]\)], "Input"],

Cell[BoxData[
    \(1 + x\^2 + 
      x\^5 - \(1\/\(6\ \[Pi]\)\) \((\[ImaginaryI]\ \((9\ \[ImaginaryI] + 
                184\ \[ImaginaryI]\ x - 18\ \[ImaginaryI]\ x\^2 - 
                48\ \[ImaginaryI]\ x\^3 - 
                9\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + \
x\)] + 240\ x\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + x\)] + 
                3\ x\^2\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + \
x\)\/\(\(-1\) + x\)] - 
                120\ x\^3\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + \
x\)\/\(\(-1\) + x\)] + 
                3\ x\^5\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + \
x\)\/\(\(-1\) + x\)] + 
                9\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + \
x\)] - 240\ x\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + x\)] - 
                3\ x\^2\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + \
x\)\/\(\(-1\) + x\)] + 
                120\ x\^3\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + \
x\)\/\(\(-1\) + x\)] - 
                3\ x\^5\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + \
x\)\/\(\(-1\) + x\)] + 9\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
                240\ x\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
                3\ x\^2\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] + 
                120\ x\^3\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
                3\ x\^5\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
                9\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
                240\ x\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
                3\ x\^2\ Log[\(2\ \[ImaginaryI] + x\)\/x] - 
                120\ x\^3\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
                3\ x\^5\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
                96\ \[ImaginaryI]\ Log[4 + x\^2] + 
                12\ \[ImaginaryI]\ x\ Log[4 + x\^2] - 
                240\ \[ImaginaryI]\ x\^2\ Log[4 + x\^2] + 
                30\ \[ImaginaryI]\ x\^4\ Log[4 + x\^2] - 
                96\ \[ImaginaryI]\ Log[5 - 2\ x + x\^2] - 
                12\ \[ImaginaryI]\ x\ Log[5 - 2\ x + x\^2] + 
                240\ \[ImaginaryI]\ x\^2\ Log[5 - 2\ x + x\^2] - 
                30\ \[ImaginaryI]\ x\^4\ Log[
                    5 - 2\ x + x\^2])\))\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0]\)], "Input"],

Cell[BoxData[
    \(1 + \(\[ImaginaryI]\ \((\(-3\)\ \[ImaginaryI] + 3\ Log[2 - \
\[ImaginaryI]] - 3\ Log[2 + \[ImaginaryI]] - 32\ \[ImaginaryI]\ Log[4] + 32\ \
\[ImaginaryI]\ Log[5])\)\)\/\(2\ \[Pi]\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(G00[
          x_] := \((1/Pi)\)*\ \((ArcTan[\(1 - x\)\/2] + 
              ArcTan[x\/2])\);\)\)], "Input"],

Cell[BoxData[
    \(\(A0[x_] := 1 - G00[x];\)\)], "Input"],

Cell[BoxData[
    \(\(Phi0[x_] := f[x]/A0[x];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Re[Phi0[x]], {x, 0, 1}, AxesOrigin \[Rule] {0, 0.9}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 -0.216975 0.252038 [
[.21429 -0.00264 -9 -9 ]
[.21429 -0.00264 9 0 ]
[.40476 -0.00264 -9 -9 ]
[.40476 -0.00264 9 0 ]
[.59524 -0.00264 -9 -9 ]
[.59524 -0.00264 9 0 ]
[.78571 -0.00264 -9 -9 ]
[.78571 -0.00264 9 0 ]
[.97619 -0.00264 -3 -9 ]
[.97619 -0.00264 3 0 ]
[.01131 .03506 -6 -4.5 ]
[.01131 .03506 0 4.5 ]
[.01131 .16108 -18 -4.5 ]
[.01131 .16108 0 4.5 ]
[.01131 .2871 -6 -4.5 ]
[.01131 .2871 0 4.5 ]
[.01131 .41312 -18 -4.5 ]
[.01131 .41312 0 4.5 ]
[.01131 .53914 -6 -4.5 ]
[.01131 .53914 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .00986 m
.21429 .01611 L
s
[(0.2)] .21429 -0.00264 0 1 Mshowa
.40476 .00986 m
.40476 .01611 L
s
[(0.4)] .40476 -0.00264 0 1 Mshowa
.59524 .00986 m
.59524 .01611 L
s
[(0.6)] .59524 -0.00264 0 1 Mshowa
.78571 .00986 m
.78571 .01611 L
s
[(0.8)] .78571 -0.00264 0 1 Mshowa
.97619 .00986 m
.97619 .01611 L
s
[(1)] .97619 -0.00264 0 1 Mshowa
.125 Mabswid
.07143 .00986 m
.07143 .01361 L
s
.11905 .00986 m
.11905 .01361 L
s
.16667 .00986 m
.16667 .01361 L
s
.2619 .00986 m
.2619 .01361 L
s
.30952 .00986 m
.30952 .01361 L
s
.35714 .00986 m
.35714 .01361 L
s
.45238 .00986 m
.45238 .01361 L
s
.5 .00986 m
.5 .01361 L
s
.54762 .00986 m
.54762 .01361 L
s
.64286 .00986 m
.64286 .01361 L
s
.69048 .00986 m
.69048 .01361 L
s
.7381 .00986 m
.7381 .01361 L
s
.83333 .00986 m
.83333 .01361 L
s
.88095 .00986 m
.88095 .01361 L
s
.92857 .00986 m
.92857 .01361 L
s
.25 Mabswid
0 .00986 m
1 .00986 L
s
.02381 .03506 m
.03006 .03506 L
s
[(1)] .01131 .03506 1 0 Mshowa
.02381 .16108 m
.03006 .16108 L
s
[(1.5)] .01131 .16108 1 0 Mshowa
.02381 .2871 m
.03006 .2871 L
s
[(2)] .01131 .2871 1 0 Mshowa
.02381 .41312 m
.03006 .41312 L
s
[(2.5)] .01131 .41312 1 0 Mshowa
.02381 .53914 m
.03006 .53914 L
s
[(3)] .01131 .53914 1 0 Mshowa
.125 Mabswid
.02381 .06027 m
.02756 .06027 L
s
.02381 .08547 m
.02756 .08547 L
s
.02381 .11067 m
.02756 .11067 L
s
.02381 .13588 m
.02756 .13588 L
s
.02381 .18629 m
.02756 .18629 L
s
.02381 .21149 m
.02756 .21149 L
s
.02381 .23669 m
.02756 .23669 L
s
.02381 .2619 m
.02756 .2619 L
s
.02381 .31231 m
.02756 .31231 L
s
.02381 .33751 m
.02756 .33751 L
s
.02381 .36271 m
.02756 .36271 L
s
.02381 .38792 m
.02756 .38792 L
s
.02381 .43832 m
.02756 .43832 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .48873 m
.02756 .48873 L
s
.02381 .51394 m
.02756 .51394 L
s
.02381 .56434 m
.02756 .56434 L
s
.02381 .58955 m
.02756 .58955 L
s
.02381 .61475 m
.02756 .61475 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01476 m
.02605 .01475 L
.02846 .01473 L
.02962 .01473 L
.03072 .01472 L
.0317 .01472 L
.03279 .01472 L
.03398 .01472 L
.03524 .01472 L
.03641 .01472 L
.0375 .01472 L
.03879 .01472 L
.03997 .01472 L
.04132 .01473 L
.04262 .01473 L
.045 .01474 L
.04753 .01476 L
.0521 .0148 L
.05752 .01487 L
.06244 .01495 L
.07287 .01517 L
.08414 .01549 L
.10458 .01628 L
.12452 .01732 L
.14558 .01872 L
.18355 .02199 L
.22398 .02659 L
.26289 .03214 L
.30425 .03934 L
.34409 .04764 L
.38242 .057 L
.42321 .06862 L
.46247 .08162 L
.50022 .09603 L
.54043 .11371 L
.57911 .13334 L
.62025 .15744 L
.65988 .18427 L
.69799 .21392 L
.73855 .25021 L
.77759 .2904 L
.81909 .33957 L
.85907 .39408 L
.89754 .45402 L
.93846 .52686 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooo`000820P:jb`k9=
NYM1Imb]`ULU>oooojjb`i>GYMcNiEePJ@00076;YF1fS;o;ecQ5D_ooooogjMSAa/c5^YVDR`0009BD
U:f][B4Q8Kfm_MkNgT92@_l0og=cLf=SHooo003oooXC@3_j=55AngemOFATI4];BlS8b>7QhIJFU_l0
0000ol2foa/K6`20001fB@1TTQ/0DP0TM_ooROooB@1B0<NaoijNWV9RHRD0L`1:L`1RUShn?X00P000
P7<0Lk77o`3o0000QXJ2Q/O3ahJ20022QXH00:n_[c8b</30`8000020P82003lo?o[jdU]KNYT0I_oo
c:ZZZ/c<c>CTi6YZJS<cIVIVc9VIo`00E@00ZP1E07moO`1EE@1EZP1Eo`2Z002ZE@2ZZP2Zo`3oE@3o
ZUD005D0EED0ZUD0oeEE05EEEEEEZUEEoeFZ05FZEEFZZUFZoeGo05GoEEGoZUGoojX00:X0EJX0ZZX0
ojYE0:YEEJYEZZYEojZZ0:ZZEJZZoj[o0:[oEJ[oZZ[oool0EOl0Z_mE0?mEEOmEZ_mEoonZ0?nZEOnZ
Z_nZooooEOooZ_GN/o_bghaoI]gNiUiPJIBGYT:JYnk^k]gMgIVIVHR8R7MgMoooonk^k]gMgLc<c;^k
^jZZZYVIVHR8R7MgMfIVIUEEEDA4A3<c<b8R8Q4A4@000<`0<iW<o]?YoeA`S8:^f9W<ofJIc9VDR`00
O`00_`0o000o?`0oO`0o_`0oo`1o06IVITA4A3<c<a4A4OogjJ0Pl00g??mV<omVc<c<oooo_mCDoh20
oe5A^/bIIYUVVC?oV@2IoaYOI`00kR8R8UDJRj>SXh^;RiT00000<`00I[^k^`00V@00c00c000c<`0c
IP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2IIP2IV@2Ic03<003<<`3<IP3<V@3<c03<
o`3o<`3oIP3oV@3oc3<003<0<c<0IS<0VC<0c3<0oc<c0?l08@000?l08@0004800P4400030@000080
104U008110000`40000400030@0002<00P4400030@0000<00P4V008110000`4000030081:P040@L0
001100040@000@P000<100009@001040004:00030@00028000@1000120001040004T00040@000@P0
00@10001:`000`4000060000@@001040004900030@0002@000@100011`050B<000@1000120001040
004T00040@000@P000@10001:`000`4000060000@@001040004:00030@0002<000@100011`001040
004T00040@000@P00`4U00040@000@T00P4/00030@0000H0001100040@000@/000<100008P001040
004800030@0102@000@1000120000`40000U00040@000@P000@10001:`000`4000060000@@001040
004800040@000B@000@100012@020B@000@1000120000`40000U00040@000@P000@10001:@030@P0
001200812P020BH00P4;00030@0002<00P4:00<19@020@X00P4/00030@0000H0000F00030@000?l0
200001H000<10000o`0800005P000`40003o00P0000?0?l14@4100005P0C0@H000<100002P000`40
000:00030@0000X000<100002P000`40000:00030@0000X000<100002P000`40000900030@0000X0
00<100002P000`40000:00030@0000X000<100002P000`40000:00030@0000X000<100002P000`40
000900030@0000X000<100001P0001H000<10000400C0@d000<10000<@000`40000`00030@000340
00<10000<0000`40000600005P000`40000S00/1f@0001H000<10000;P080M40000=00@11@000`40
000f00D1c00000l000<1000010000`40000k00D1a`0000l000<1000010020D401P7100003`000`40
000400030@0004H01P6k00003`000`40000400030@0004`01@6f00003@030@H000<10000D@040K80
000?00030@0000@000<10000E@040Jh0000F00030@0005T0106Z00005P000`40001M00<1Y`0001H0
0P5Q00@1X`0001H000<10000I0040Il0000F00030@0006P00`6L00005P000`40001[00<1V@0001H0
00<10000KP040ID0000F00030@0007800`6B00005P020GH00`6?00005P000`40001h0081S@0001H0
00<10000NP030HX0000F00030@0007d00P6800005P000`40001o0081QP0001H000<10000P@020H@0
000F00030@0008<00P6200005P020HH00P6000005P000`40002700<1O@0001H000<10000RP020G/0
000F00030@0008`00P5i00005P000`40002>0081M`0001H000<10000T0020GD0000F00030@000980
0P5c00005P020ID00P5a00005P000`40002F00030@0006h0000F00030@0009L00P5^00005P000`40
002I0081K00001H000<10000V`000`40001Y000000<00@400P4300030@0000800`4600030@0009`0
0P5Y00000`000`40000:00030@0000<000<10000WP000`40001V00000`000`40000:00030@0000<0
0P6P0081IP0000<000<100001`030@H000<10000X@000`40001S00000`000`40000700030@0000H0
00<10000XP020F<0000010010@4900030@0000H000<10000Y0020F40000300030@0000L010450003
0@000:H000<10000GP0001H000<10000Y`020Eh0000F00030@000:T000<10000F`0001H00P6[0003
0@0005X0000F00030@000:/00P5J00005P000`40002]00030@0005L0000F00030@000:h000<10000
EP0001H000<10000[`000`40001E00005P000`40002`0081E@0001H00P6c00030@000580000F0003
0@000;<000<10000D@0001H000<10000]0000`40001@00005P000`40002e00030@0004l0000F0003
0@000;H000<10000CP0001H000<10000]`000`40001=00005P000`40002h0081C@0001H00P6k0003
0@0004X0000F00030@000;/000<10000B@0001H000<10000_0000`40001800005P000`40002m0003
0@0004L0000F00030@000;h000<10000AP0001H000<10000_`000`40001500005P000`4000300003
0@0004@0000F0081`P000`40001300005P000`40003200030@000480000F00030@000<<000<10000
@@0001H000<10000a0000`40001000005P000`40003500030@0003l0000=00@11@000`4000360003
0@0003h0000=00030@0000H000<10000a`000`40000m00003P000`4000050081b@000`40000l0000
3`000`40000400030@000<T000<10000>`00010000<100000`000`40003:00030@0003X0000=0004
0@000@D000<10000b`000`40000i00003P020@H000<10000c0000`40000h00005P000`40003<0003
0@0003P0000F00030@000<d000<10000=`0001H00P7?00030@0003H0000F00030@000<l000<10000
=@0001H000<10000d0000`40000d00005P000`40003A00030@0003<0000F00030@000=4000<10000
<`0001H000<10000dP000`40000b00005P000`40003C00030@000340000F0081e@000`40000`0000
5P000`40003E00030@0002l0000F00030@000=D000<10000;`0001H000<10000eP000`40000^0000
5P000`40003G00030@0002d0000F00030@000=P000<10000;00001H00P7I00030@0002`0000F0003
0@000=T000<10000:`0001H000<10000fP000`40000Z00005P000`40003K00030@0002T0000F0003
0@000=/000<10000:@0001H000<10000g0000`40000X00005P000`40003M00030@0002L0000F0081
g`000`40000V00005P000`40003N00030@0002H0000F00030@000=l000<100009@0001H000<10000
h0000`40000T00005P000`40003P00030@0002@000000`010@020@<000<100000P030@H000<10000
h@000`40000S000000<00@003@000`40000300030@000>4000<100008`00008000<100002`000`40
00030081h`000`40000R00000`000`40000700<11P000`40003S00030@000240000400030@0000H0
00<100001P000`40003S00030@00024000001@01000100P000<100001P000`40003T00030@000200
000200812@040@D000<10000i@000`40000O00005P000`40003U00030@0001l0000F00030@000>H0
00<100007P0001H00P7W00030@0001h0000F00030@000>L000<100007@0001H000<10000j0000`40
000L00005P000`40003X00030@0001`0000F00030@000>T000<100006`0001H000<10000jP000`40
000J00005P000`40003Z00030@0001X0000F0081k0000`40000I00005P000`40003[00030@0001T0
000F00030@000>`000<10000600001H000<10000k0000`40000H00005P000`40003]00030@0001L0
000F00030@000>d000<100005`0001H000<10000kP000`40000F00005P020Nl000<100005P0001H0
00<10000k`000`40000E00005P000`40003`00030@0001@0000F00030@000?0000<10000500001H0
00<10000l@000`40000C00005P000`40003a00030@0001<0000F0081l`000`40000B00005P000`40
003b00030@000180000F00030@000?<000<100004@0001H000<10000l`000`40000A00005P000`40
003d00030@000100000>00811P000`40003d00030@000100000=00040@000@D000<10000m@000`40
000?000040000`4000030081mP000`40000?00003P020@H000<10000mP000`40000>000040000`40
000300030@000?H000<100003P0000d000@100011@000`40003g00030@0000d0000>00811P000`40
003g00030@0000d0000F00030@000?P000<10000300001H000<10000n0000`40000<00005P020OX0
00<100002`0001H000<10000n@000`40000;00005P000`40003j00030@0000X0000F00030@000?X0
00<100002P0001H000<10000n`000`40000900005P000`40003k00030@0000T0000F00030@000?`0
00<10000200001H00P7m00030@0000P0000F00030@000?d000<100001`0001H000<10000o@000`40
000700005P000`40003n00030@0000H0000F00030@000?h000<100001P0001H000<10000o`080000
5P000`40003o00P0000F0081o`090000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0858644, 0.718419, \
0.00388067, 0.014664}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(G01[x_] := Integrate[k[x, s]*\((s - x)\), {s, 0, 1}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G01[x]\)], "Input"],

Cell[BoxData[
    \(1\/2\ \((\(-Log[4 + x\^2]\) + Log[5 - 2\ x + x\^2])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[k[x, s], x]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(2\ \((\(-s\) + 
                x)\)\)\/\((4 + \((\(-s\) + x)\)\^2)\)\^2\)\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(G10[x_] := 
        Integrate[\(-\(\(2\ \((\(-s\) + 
                      x)\)\)\/\((4 + \((\(-s\) + x)\)\^2)\)\^2\)\), {s, 0, 
            1}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G10[x]\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ \((\(-\(1\/\(2\ \((4 + x\^2)\)\)\)\) + 
          1\/\(2\ \((5 - 2\ x + x\^2)\)\))\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[f[x], x]\)], "Input"],

Cell[BoxData[
    \(2\ x + 
      5\ x\^4 - \(1\/\(6\ \[Pi]\)\) \((\[ImaginaryI]\ \((184\ \[ImaginaryI] - \
\(9\ \((1\/\(\(-1\) + x\) - \(\((\(-1\) - 2\ \[ImaginaryI])\) + \
x\)\/\((\(-1\) + x)\)\^2)\)\ \((\(-1\) + x)\)\)\/\(\((\(-1\) - 2\ \
\[ImaginaryI])\) + x\) + \(9\ \((1\/\(\(-1\) + x\) - \(\((\(-1\) + 2\ \
\[ImaginaryI])\) + x\)\/\((\(-1\) + x)\)\^2)\)\ \((\(-1\) + x)\)\)\/\(\((\(-1\
\) + 2\ \[ImaginaryI])\) + x\) - 
                36\ \[ImaginaryI]\ x + \(240\ \((1\/\(\(-1\) + x\) - \
\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\((\(-1\) + x)\)\^2)\)\ \((\(-1\) + \
x)\)\ x\)\/\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\) - \(240\ \((1\/\(\(-1\) + \
x\) - \(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\((\(-1\) + x)\)\^2)\)\ \
\((\(-1\) + x)\)\ x\)\/\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\) - 
                144\ \[ImaginaryI]\ x\^2 + \(3\ \((1\/\(\(-1\) + x\) - \
\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\((\(-1\) + x)\)\^2)\)\ \((\(-1\) + \
x)\)\ x\^2\)\/\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\) - \(3\ \((1\/\(\(-1\) + \
x\) - \(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\((\(-1\) + x)\)\^2)\)\ \
\((\(-1\) + x)\)\ x\^2\)\/\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\) - \(120\ \
\((1\/\(\(-1\) + x\) - \(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\((\(-1\) + \
x)\)\^2)\)\ \((\(-1\) + x)\)\ x\^3\)\/\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\) \
+ \(120\ \((1\/\(\(-1\) + x\) - \(\((\(-1\) + 2\ \[ImaginaryI])\) + \
x\)\/\((\(-1\) + x)\)\^2)\)\ \((\(-1\) + x)\)\ x\^3\)\/\(\((\(-1\) + 2\ \
\[ImaginaryI])\) + x\) + \(3\ \((1\/\(\(-1\) + x\) - \(\((\(-1\) - 2\ \
\[ImaginaryI])\) + x\)\/\((\(-1\) + x)\)\^2)\)\ \((\(-1\) + x)\)\ \
x\^5\)\/\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\) - \(3\ \((1\/\(\(-1\) + x\) - \
\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\((\(-1\) + x)\)\^2)\)\ \((\(-1\) + \
x)\)\ x\^5\)\/\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\) + \(192\ \[ImaginaryI]\ \
x\)\/\(4 + x\^2\) + \(24\ \[ImaginaryI]\ x\^2\)\/\(4 + x\^2\) - \(480\ \
\[ImaginaryI]\ x\^3\)\/\(4 + x\^2\) + \(60\ \[ImaginaryI]\ x\^5\)\/\(4 + x\^2\
\) - \(96\ \[ImaginaryI]\ \((\(-2\) + 2\ x)\)\)\/\(5 - 2\ x + x\^2\) - \(12\ \
\[ImaginaryI]\ x\ \((\(-2\) + 2\ x)\)\)\/\(5 - 2\ x + x\^2\) + \(240\ \
\[ImaginaryI]\ x\^2\ \((\(-2\) + 2\ x)\)\)\/\(5 - 2\ x + x\^2\) - \(30\ \
\[ImaginaryI]\ x\^4\ \((\(-2\) + 2\ x)\)\)\/\(5 - 2\ x + x\^2\) + \(9\ x\ \
\((1\/x - \(\(-2\)\ \[ImaginaryI] + x\)\/x\^2)\)\)\/\(\(-2\)\ \[ImaginaryI] + \
x\) - \(240\ x\^2\ \((1\/x - \(\(-2\)\ \[ImaginaryI] + x\)\/x\^2)\)\)\/\(\(-2\
\)\ \[ImaginaryI] + x\) - \(3\ x\^3\ \((1\/x - \(\(-2\)\ \[ImaginaryI] + \
x\)\/x\^2)\)\)\/\(\(-2\)\ \[ImaginaryI] + x\) + \(120\ x\^4\ \((1\/x - \(\(-2\
\)\ \[ImaginaryI] + x\)\/x\^2)\)\)\/\(\(-2\)\ \[ImaginaryI] + x\) - \(3\ x\^6\
\ \((1\/x - \(\(-2\)\ \[ImaginaryI] + x\)\/x\^2)\)\)\/\(\(-2\)\ \[ImaginaryI] \
+ x\) - \(9\ x\ \((1\/x - \(2\ \[ImaginaryI] + x\)\/x\^2)\)\)\/\(2\ \
\[ImaginaryI] + x\) + \(240\ x\^2\ \((1\/x - \(2\ \[ImaginaryI] + \
x\)\/x\^2)\)\)\/\(2\ \[ImaginaryI] + x\) + \(3\ x\^3\ \((1\/x - \(2\ \
\[ImaginaryI] + x\)\/x\^2)\)\)\/\(2\ \[ImaginaryI] + x\) - \(120\ x\^4\ \
\((1\/x - \(2\ \[ImaginaryI] + x\)\/x\^2)\)\)\/\(2\ \[ImaginaryI] + x\) + \(3\
\ x\^6\ \((1\/x - \(2\ \[ImaginaryI] + x\)\/x\^2)\)\)\/\(2\ \[ImaginaryI] + x\
\) + 240\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + x\)] + 
                6\ x\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + \
x\)] - 360\ x\^2\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + \
x\)] + 15\ x\^4\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + x\)] \
- 240\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + x\)] - 
                6\ x\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + \
x\)] + 360\ x\^2\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + \
x\)] - 15\ x\^4\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\(\(-1\) + x\)] \
- 240\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
                6\ x\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] + 
                360\ x\^2\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
                15\ x\^4\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] + 
                240\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
                6\ x\ Log[\(2\ \[ImaginaryI] + x\)\/x] - 
                360\ x\^2\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
                15\ x\^4\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
                12\ \[ImaginaryI]\ Log[4 + x\^2] - 
                480\ \[ImaginaryI]\ x\ Log[4 + x\^2] + 
                120\ \[ImaginaryI]\ x\^3\ Log[4 + x\^2] - 
                12\ \[ImaginaryI]\ Log[5 - 2\ x + x\^2] + 
                480\ \[ImaginaryI]\ x\ Log[5 - 2\ x + x\^2] - 
                120\ \[ImaginaryI]\ x\^3\ Log[
                    5 - 2\ x + x\^2])\))\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[BoxData[
    \(\((4484 - 2936\ x + 240\ \[Pi]\ x - 1116\ x\^2 - 96\ \[Pi]\ x\^2 + 
          460\ x\^3 + 108\ \[Pi]\ x\^3 - 1280\ x\^4 + 576\ \[Pi]\ x\^4 + 
          300\ x\^5 - 228\ \[Pi]\ x\^5 - 180\ x\^6 + 270\ \[Pi]\ x\^6 - 
          60\ \[Pi]\ x\^7 + 30\ \[Pi]\ x\^8 - 
          3\ \[ImaginaryI]\ \((1600 - 600\ x - 1696\ x\^2 + 818\ x\^3 - 
                904\ x\^4 + 202\ x\^5 - 75\ x\^6 - 10\ x\^7 + 
                5\ x\^8)\)\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + \
x\)\/\(\(-1\) + x\)] + 
          3\ \[ImaginaryI]\ \((1600 - 600\ x - 1696\ x\^2 + 818\ x\^3 - 
                904\ x\^4 + 202\ x\^5 - 75\ x\^6 - 10\ x\^7 + 
                5\ x\^8)\)\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + \
x\)\/\(\(-1\) + x\)] + 
          4800\ \[ImaginaryI]\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
          1800\ \[ImaginaryI]\ x\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
          5088\ \[ImaginaryI]\ x\^2\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] + 
          2454\ \[ImaginaryI]\ x\^3\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
          2712\ \[ImaginaryI]\ x\^4\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] + 
          606\ \[ImaginaryI]\ x\^5\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
          225\ \[ImaginaryI]\ x\^6\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
          30\ \[ImaginaryI]\ x\^7\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] + 
          15\ \[ImaginaryI]\ x\^8\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
          4800\ \[ImaginaryI]\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
          1800\ \[ImaginaryI]\ x\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
          5088\ \[ImaginaryI]\ x\^2\ Log[\(2\ \[ImaginaryI] + x\)\/x] - 
          2454\ \[ImaginaryI]\ x\^3\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
          2712\ \[ImaginaryI]\ x\^4\ Log[\(2\ \[ImaginaryI] + x\)\/x] - 
          606\ \[ImaginaryI]\ x\^5\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
          225\ \[ImaginaryI]\ x\^6\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
          30\ \[ImaginaryI]\ x\^7\ Log[\(2\ \[ImaginaryI] + x\)\/x] - 
          15\ \[ImaginaryI]\ x\^8\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
          240\ Log[4 + x\^2] - 9696\ x\ Log[4 + x\^2] + 
          3948\ x\^2\ Log[4 + x\^2] - 1944\ x\^3\ Log[4 + x\^2] + 
          12\ x\^4\ Log[4 + x\^2] + 600\ x\^5\ Log[4 + x\^2] - 
          240\ x\^6\ Log[4 + x\^2] + 120\ x\^7\ Log[4 + x\^2] - 
          240\ Log[5 - 2\ x + x\^2] + 9696\ x\ Log[5 - 2\ x + x\^2] - 
          3948\ x\^2\ Log[5 - 2\ x + x\^2] + 
          1944\ x\^3\ Log[5 - 2\ x + x\^2] - 12\ x\^4\ Log[5 - 2\ x + x\^2] - 
          600\ x\^5\ Log[5 - 2\ x + x\^2] + 240\ x\^6\ Log[5 - 2\ x + x\^2] - 
          120\ x\^7\ Log[
              5 - 2\ x + 
                x\^2])\)/\((6\ \[Pi]\ \((\((\(-1\) - 2\ \[ImaginaryI])\) + 
              x)\)\ \((\((\(-1\) + 2\ \[ImaginaryI])\) + 
              x)\)\ \((\(-2\)\ \[ImaginaryI] + x)\)\ \((2\ \[ImaginaryI] + 
              x)\))\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(f1[
          x_] := \((4484 - 2936\ x + 240\ \[Pi]\ x - 1116\ x\^2 - 
              96\ \[Pi]\ x\^2 + 460\ x\^3 + 108\ \[Pi]\ x\^3 - 1280\ x\^4 + 
              576\ \[Pi]\ x\^4 + 300\ x\^5 - 228\ \[Pi]\ x\^5 - 180\ x\^6 + 
              270\ \[Pi]\ x\^6 - 60\ \[Pi]\ x\^7 + 30\ \[Pi]\ x\^8 - 
              3\ \[ImaginaryI]\ \((1600 - 600\ x - 1696\ x\^2 + 818\ x\^3 - 
                    904\ x\^4 + 202\ x\^5 - 75\ x\^6 - 10\ x\^7 + 
                    5\ x\^8)\)\ Log[\(\((\(-1\) - 2\ \[ImaginaryI])\) + x\)\/\
\(\(-1\) + x\)] + 
              3\ \[ImaginaryI]\ \((1600 - 600\ x - 1696\ x\^2 + 818\ x\^3 - 
                    904\ x\^4 + 202\ x\^5 - 75\ x\^6 - 10\ x\^7 + 
                    5\ x\^8)\)\ Log[\(\((\(-1\) + 2\ \[ImaginaryI])\) + x\)\/\
\(\(-1\) + x\)] + 
              4800\ \[ImaginaryI]\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
              1800\ \[ImaginaryI]\ x\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
              5088\ \[ImaginaryI]\ x\^2\ Log[\(\(-2\)\ \[ImaginaryI] + \
x\)\/x] + 2454\ \[ImaginaryI]\ x\^3\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
              2712\ \[ImaginaryI]\ x\^4\ Log[\(\(-2\)\ \[ImaginaryI] + \
x\)\/x] + 606\ \[ImaginaryI]\ x\^5\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] - 
              225\ \[ImaginaryI]\ x\^6\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] \
- 30\ \[ImaginaryI]\ x\^7\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] + 
              15\ \[ImaginaryI]\ x\^8\ Log[\(\(-2\)\ \[ImaginaryI] + x\)\/x] \
- 4800\ \[ImaginaryI]\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
              1800\ \[ImaginaryI]\ x\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
              5088\ \[ImaginaryI]\ x\^2\ Log[\(2\ \[ImaginaryI] + x\)\/x] - 
              2454\ \[ImaginaryI]\ x\^3\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
              2712\ \[ImaginaryI]\ x\^4\ Log[\(2\ \[ImaginaryI] + x\)\/x] - 
              606\ \[ImaginaryI]\ x\^5\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
              225\ \[ImaginaryI]\ x\^6\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
              30\ \[ImaginaryI]\ x\^7\ Log[\(2\ \[ImaginaryI] + x\)\/x] - 
              15\ \[ImaginaryI]\ x\^8\ Log[\(2\ \[ImaginaryI] + x\)\/x] + 
              240\ Log[4 + x\^2] - 9696\ x\ Log[4 + x\^2] + 
              3948\ x\^2\ Log[4 + x\^2] - 1944\ x\^3\ Log[4 + x\^2] + 
              12\ x\^4\ Log[4 + x\^2] + 600\ x\^5\ Log[4 + x\^2] - 
              240\ x\^6\ Log[4 + x\^2] + 120\ x\^7\ Log[4 + x\^2] - 
              240\ Log[5 - 2\ x + x\^2] + 9696\ x\ Log[5 - 2\ x + x\^2] - 
              3948\ x\^2\ Log[5 - 2\ x + x\^2] + 
              1944\ x\^3\ Log[5 - 2\ x + x\^2] - 
              12\ x\^4\ Log[5 - 2\ x + x\^2] - 
              600\ x\^5\ Log[5 - 2\ x + x\^2] + 
              240\ x\^6\ Log[5 - 2\ x + x\^2] - 
              120\ x\^7\ Log[
                  5 - 2\ x + 
                    x\^2])\)/\((6\ \[Pi]\ \((\((\(-1\) - 
                      2\ \[ImaginaryI])\) + 
                  x)\)\ \((\((\(-1\) + 2\ \[ImaginaryI])\) + 
                  x)\)\ \((\(-2\)\ \[ImaginaryI] + 
                  x)\)\ \((2\ \[ImaginaryI] + x)\))\);\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f1[0]\)], "Input"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Power :: \"infy\"\) will be suppressed during \
this calculation."\)], "Message"],

Cell[BoxData[
    \(Indeterminate\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[f1[x], x \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \(\(1121 + 1200\ \[Pi] + 1200\ \[ImaginaryI]\ Log[1 - 2\ \[ImaginaryI]] - \
1200\ \[ImaginaryI]\ Log[1 + 2\ \[ImaginaryI]] + 60\ Log[4] - 60\ \
Log[5]\)\/\(30\ \[Pi]\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(\(\(79.9454324048567`\)\(\[InvisibleSpace]\)\) + 
      0.`\ \[ImaginaryI]\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{727, 575},
WindowMargins->{{32, Automatic}, {Automatic, 0}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 87, 1, 27, "Input"],
Cell[1807, 52, 156, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[1988, 60, 37, 1, 27, "Input"],
Cell[2028, 63, 2199, 38, 280, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4264, 106, 37, 1, 27, "Input"],
Cell[4304, 109, 214, 3, 42, "Output"]
}, Open  ]],
Cell[4533, 115, 129, 3, 42, "Input"],
Cell[4665, 120, 58, 1, 27, "Input"],
Cell[4726, 123, 60, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[4811, 128, 90, 1, 27, "Input"],
Cell[4904, 131, 10599, 348, 186, 3762, 259, "GraphicsData", "PostScript", \
"Graphics"],
Cell[15506, 481, 130, 3, 70, "Output"]
}, Open  ]],
Cell[15651, 487, 90, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[15766, 492, 39, 1, 70, "Input"],
Cell[15808, 495, 87, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15932, 501, 46, 1, 70, "Input"],
Cell[15981, 504, 117, 2, 70, "Output"]
}, Open  ]],
Cell[16113, 509, 182, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[16320, 517, 39, 1, 70, "Input"],
Cell[16362, 520, 126, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16525, 527, 43, 1, 70, "Input"],
Cell[16571, 530, 4719, 67, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21327, 602, 44, 1, 70, "Input"],
Cell[21374, 605, 2896, 44, 70, "Output"]
}, Open  ]],
Cell[24285, 652, 3086, 48, 70, "Input"],

Cell[CellGroupData[{
Cell[27396, 704, 38, 1, 70, "Input"],
Cell[27437, 707, 117, 2, 70, "Message"],
Cell[27557, 711, 117, 2, 70, "Message"],
Cell[27677, 715, 117, 2, 70, "Message"],
Cell[27797, 719, 163, 3, 70, "Message"],
Cell[27963, 724, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28047, 730, 58, 1, 70, "Input"],
Cell[28108, 733, 199, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28344, 741, 37, 1, 70, "Input"],
Cell[28384, 744, 108, 2, 70, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

